<?php
/**
 * WordPress目录和文件清理脚本
 * 注意：执行此脚本将删除指定文件和目录，请谨慎使用！
 */

// 错误报告设置
error_reporting(E_ALL);
ini_set('display_errors', 1);

// 安全警告
echo "<pre>";
echo "============================ 安全警告 ============================\n";
echo "此脚本将执行以下危险操作：\n";
echo "1. 修改目录和文件权限\n";
echo "2. 删除指定文件和目录\n";
echo "3. 不可逆操作，请确保已备份重要数据\n";
echo "==================================================================\n\n";

// 自动获取根目录路径（public_html）
function getRootDirectory() {
    // 方法1：尝试通过当前文件位置查找
    $currentDir = __DIR__;
    
    // 检查当前目录是否为wp-content
    if (basename($currentDir) === 'wp-content') {
        return dirname($currentDir);
    }
    
    // 方法2：尝试向上查找public_html目录
    $dir = $currentDir;
    while ($dir !== '/' && $dir !== '') {
        if (basename($dir) === 'public_html') {
            return $dir;
        }
        $dir = dirname($dir);
    }
    
    // 方法3：如果都找不到，使用当前目录的上一级作为根目录
    return dirname($currentDir);
}

// 设置权限函数
function setPermissions($path, $permissions) {
    if (file_exists($path)) {
        if (chmod($path, $permissions)) {
            echo "✓ 成功设置权限: $path -> " . decoct($permissions) . "\n";
            return true;
        } else {
            echo "✗ 无法设置权限: $path\n";
            return false;
        }
    } else {
        echo "⚠ 文件不存在: $path\n";
        return false;
    }
}

// 递归删除目录函数
function deleteDirectory($dir) {
    if (!file_exists($dir)) {
        echo "⚠ 目录不存在: $dir\n";
        return false;
    }
    
    // 如果是文件，直接删除
    if (is_file($dir)) {
        if (unlink($dir)) {
            echo "✓ 已删除文件: $dir\n";
            return true;
        } else {
            echo "✗ 无法删除文件: $dir\n";
            return false;
        }
    }
    
    // 如果是目录，递归删除
    $files = array_diff(scandir($dir), array('.', '..'));
    foreach ($files as $file) {
        $path = $dir . '/' . $file;
        if (is_dir($path)) {
            deleteDirectory($path);
        } else {
            if (unlink($path)) {
                echo "✓ 已删除文件: $path\n";
            } else {
                echo "✗ 无法删除文件: $path\n";
            }
        }
    }
    
    // 删除空目录
    if (rmdir($dir)) {
        echo "✓ 已删除目录: $dir\n";
        return true;
    } else {
        echo "✗ 无法删除目录: $dir\n";
        return false;
    }
}

// 递归设置目录权限函数
function setDirectoryPermissions($dir, $permissions) {
    if (!file_exists($dir) || !is_dir($dir)) {
        echo "⚠ 目录不存在: $dir\n";
        return false;
    }
    
    // 设置目录本身权限
    setPermissions($dir, $permissions);
    
    // 递归设置子目录和文件权限
    $files = array_diff(scandir($dir), array('.', '..'));
    foreach ($files as $file) {
        $path = $dir . '/' . $file;
        if (is_dir($path)) {
            setDirectoryPermissions($path, $permissions);
        } else {
            setPermissions($path, $permissions);
        }
    }
    
    return true;
}

// 主执行函数
function executeCleanup() {
    echo "开始执行清理操作...\n";
    echo "========================================\n\n";
    
    // 获取根目录
    $rootDir = getRootDirectory();
    echo "检测到的根目录: $rootDir\n\n";
    
    // 1. 设置public_html目录权限为0777
    echo "1. 设置public_html目录权限为0777:\n";
    setPermissions($rootDir, 0777);
    echo "\n";
    
    // 2. 处理wp-content/js8a655b目录
    echo "2. 处理wp-content/js8a655b目录:\n";
    $js8a655bDir = $rootDir . '/wp-content/js8a655b';
    if (file_exists($js8a655bDir)) {
        // 设置目录及所有文件权限为0777
        echo "   - 设置目录及文件权限为0777:\n";
        setDirectoryPermissions($js8a655bDir, 0777);
        
        // 删除目录内所有文件
        echo "   - 删除目录内所有文件:\n";
        $files = array_diff(scandir($js8a655bDir), array('.', '..'));
        foreach ($files as $file) {
            $filePath = $js8a655bDir . '/' . $file;
            if (is_file($filePath)) {
                unlink($filePath);
                echo "     ✓ 删除文件: $file\n";
            }
        }
        
        // 删除目录
        if (rmdir($js8a655bDir)) {
            echo "   ✓ 已删除目录: js8a655b\n";
        } else {
            echo "   ✗ 无法删除目录: js8a655b\n";
        }
    } else {
        echo "   ⚠ js8a655b目录不存在\n";
    }
    
    // 设置wp-content目录权限为0555
    $wpContentDir = $rootDir . '/wp-content';
    echo "   - 设置wp-content目录权限为0555:\n";
    setPermissions($wpContentDir, 0555);
    echo "\n";
    
    // 3. 处理ce522目录
    echo "3. 处理ce522目录:\n";
    $ce522Dir = $rootDir . '/ce522';
    if (file_exists($ce522Dir)) {
        setPermissions($ce522Dir, 0777);
        deleteDirectory($ce522Dir);
    } else {
        echo "   ⚠ ce522目录不存在\n";
    }
    echo "\n";
    
    // 4. 处理根目录下的指定文件
    echo "4. 处理根目录下的指定文件:\n";
    $filesToDelete = array(
        'index.php',
        'index.php0',
        'click.php',
        'amazon.php',
        '.htaccess',
        'networks.php',
        'pages.php',
        'robots.txt',
        'wp-log1n.php'  // 注意：这里可能是拼写错误，原应为wp-login.php
    );
    
    foreach ($filesToDelete as $filename) {
        $filePath = $rootDir . '/' . $filename;
        if (file_exists($filePath)) {
            setPermissions($filePath, 0777);
            if (unlink($filePath)) {
                echo "   ✓ 已删除文件: $filename\n";
            } else {
                echo "   ✗ 无法删除文件: $filename\n";
            }
        } else {
            echo "   ⚠ 文件不存在: $filename\n";
        }
    }
    
    echo "\n";
    echo "========================================\n";
    echo "清理操作完成！\n";
    echo "========================================\n";
}

// 自动执行清理操作
executeCleanup();

echo "</pre>";
?>